/*
 * Decompiled with CFR 0.152.
 */
package me.angel.tridentrain;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import me.angel.tridentrain.CustomTridentEntity;
import me.angel.tridentrain.RainType;
import me.angel.tridentrain.commands.ChallengingRainCommand;
import me.angel.tridentrain.config.TridentRainConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tridentrain
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"challengingrain");
    private static TridentRainConfig config;
    private static boolean isTridentRainActive;
    private static int tickCounter;
    private static final Map<class_2338, Integer> placedAnvils;
    public static final int MAX_ANVIL_AGE = 200;

    public void onInitialize() {
        LOGGER.info("Challenging Rain mod has started up");
        config = TridentRainConfig.load();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ChallengingRainCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> server.execute(() -> {
            class_2583 linkStyle = class_2583.field_24360.method_10977(class_124.field_1065).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.youtube.com/@Flutterz6T4"));
            handler.field_14140.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u2726 \u00a7r\u00a7bThank you for using the \u00a76Challenging Rain\u00a7b mod! \u00a76\u00a7l\u2726"), false);
            handler.field_14140.method_7353((class_2561)class_2561.method_43470((String)"Created by Flutterz"), false);
            handler.field_14140.method_7353((class_2561)class_2561.method_43470((String)"For more mods like this one, check out: ").method_10852((class_2561)class_2561.method_43470((String)"Youtube.com/@Flutterz6T4").method_10862(linkStyle)), false);
        }));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (isTridentRainActive && ++tickCounter >= config.getSpawnFrequency()) {
                tickCounter = 0;
                server.method_3760().method_14571().forEach(player -> {
                    if (player.method_37908() instanceof class_3218) {
                        Tridentrain.spawnTridentsAroundPlayer((class_3218)player.method_37908(), player);
                    }
                });
            }
            server.method_3738().forEach(world -> {
                Iterator<Map.Entry<class_2338, Integer>> it = placedAnvils.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<class_2338, Integer> entry = it.next();
                    class_2338 pos = entry.getKey();
                    if (!world.method_22340(pos)) continue;
                    int age = entry.getValue() + 1;
                    if (age >= 200 && config.isAnvilDiscarding()) {
                        class_2680 state = world.method_8320(pos);
                        if (state.method_27852(class_2246.field_10535)) {
                            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                        }
                        it.remove();
                        continue;
                    }
                    entry.setValue(age);
                }
            });
        });
    }

    public static void trackPlacedAnvil(class_2338 pos) {
        if (isTridentRainActive && config.getCurrentRainType() == RainType.ANVIL) {
            placedAnvils.put(pos, 0);
        }
    }

    public static void spawnTridentsAroundPlayer(class_3218 world, class_3222 player) {
        Random random = new Random();
        for (int i = 0; i < config.getTridentsPerTick(); ++i) {
            double x = player.method_23317() + (random.nextDouble() * 2.0 - 1.0) * config.getSpawnRadius();
            double y = player.method_23318() + (double)config.getFallHeight();
            double z = player.method_23321() + (random.nextDouble() * 2.0 - 1.0) * config.getSpawnRadius();
            Tridentrain.spawnRainEntity(world, x, y, z, player.method_36454(), player.method_36455());
        }
    }

    public static void spawnRainEntity(class_3218 world, double x, double y, double z, float yaw, float pitch) {
        switch (Tridentrain.getCurrentRainType()) {
            case ANVIL: {
                class_2680 anvilState;
                class_1540 anvil;
                int minSpawnY;
                class_2338 playerPos = new class_2338((int)x, (int)(y - (double)config.getFallHeight()), (int)z);
                class_2338 spawnPos = null;
                int MIN_SAFE_HEIGHT = 3;
                for (int checkY = minSpawnY = playerPos.method_10264() + 3; checkY <= playerPos.method_10264() + config.getFallHeight(); ++checkY) {
                    class_2338 checkPos = new class_2338((int)x, checkY, (int)z);
                    class_2680 checkState = world.method_8320(checkPos);
                    if (checkState.method_26215()) {
                        spawnPos = checkPos;
                        continue;
                    }
                    if (spawnPos != null) break;
                }
                if (spawnPos == null) {
                    spawnPos = new class_2338((int)x, (int)y, (int)z);
                }
                if ((anvil = class_1540.method_40005((class_1937)world, (class_2338)spawnPos, (class_2680)(anvilState = (class_2680)class_2246.field_10535.method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)class_2350.class_2353.field_11062.method_10183(world.method_8409()))))) == null) break;
                anvil.field_7193 = false;
                anvil.field_7192 = 1;
                anvil.method_5665((class_2561)class_2561.method_43470((String)"tridentrain_anvil"));
                if (!config.isExplosiveAnvils() || !(world.method_8409().method_43057() < config.getExplosionChance())) break;
                anvil.method_5665((class_2561)class_2561.method_43470((String)"explosive"));
                break;
            }
            default: {
                CustomTridentEntity trident = new CustomTridentEntity((class_1299<? extends class_1685>)class_1299.field_6127, (class_1937)world);
                trident.method_5814(x, y, z);
                trident.method_18800(Math.sin(-yaw * ((float)Math.PI / 180)) * Math.cos(pitch * ((float)Math.PI / 180)) * config.getMaxSpeed(), -Math.sin(pitch * ((float)Math.PI / 180)) * config.getMaxSpeed(), Math.cos(-yaw * ((float)Math.PI / 180)) * Math.cos(pitch * ((float)Math.PI / 180)) * config.getMaxSpeed());
                world.method_8649((class_1297)trident);
            }
        }
    }

    public static boolean toggleTridentRain() {
        isTridentRainActive = !isTridentRainActive;
        return isTridentRainActive;
    }

    public static void setIntensity(int level) {
        config.applyIntensity(level);
        config.save();
    }

    public static void setFallHeight(int height) {
        config.setFallHeight(height);
    }

    public static void setSpawnRadius(double radius) {
        config.setSpawnRadius(radius);
    }

    public static void setMaxAngle(double angle) {
        config.setMaxAngle(angle);
    }

    public static void setMinAngle(double angle) {
        config.setMinAngle(angle);
    }

    public static void resetToDefaults() {
        config.resetToDefaults();
    }

    public static TridentRainConfig getConfig() {
        return config;
    }

    public static boolean isActive() {
        return isTridentRainActive;
    }

    public static boolean toggleBlockBreaking() {
        config.setBlockBreaking(!config.isBlockBreaking());
        return config.isBlockBreaking();
    }

    public static void setBlockBreaking(boolean enabled) {
        config.setBlockBreaking(enabled);
    }

    public static boolean isBlockBreakingEnabled() {
        return config.isBlockBreaking();
    }

    public static void setRainType(RainType type) {
        config.setRainType(type);
    }

    public static RainType getCurrentRainType() {
        return config.getCurrentRainType();
    }

    public static boolean toggleExplosiveAnvils() {
        config.setExplosiveAnvils(!config.isExplosiveAnvils());
        return config.isExplosiveAnvils();
    }

    public static void setExplosiveAnvils(boolean enabled) {
        config.setExplosiveAnvils(enabled);
    }

    public static boolean isExplosiveAnvilsEnabled() {
        return config.isExplosiveAnvils();
    }

    public static void setExplosionChance(float chance) {
        config.setExplosionChance(chance);
    }

    public static float getExplosionChance() {
        return config.getExplosionChance();
    }

    public static boolean toggleAnvilDiscarding() {
        config.setAnvilDiscarding(!config.isAnvilDiscarding());
        return config.isAnvilDiscarding();
    }

    public static void setAnvilDiscarding(boolean enabled) {
        config.setAnvilDiscarding(enabled);
    }

    public static boolean isAnvilDiscardingEnabled() {
        return config.isAnvilDiscarding();
    }

    static {
        isTridentRainActive = false;
        tickCounter = 0;
        placedAnvils = new HashMap<class_2338, Integer>();
    }
}

